/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd;

import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.base.vpd.AbstractVpd;
import com.ibm.hwmca.base.vpd.VpdErrorIds;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class VpdTasks
extends AbstractVpd
implements VpdErrorIds {
    private static final String TRACE_MASKT = "HCONVPDT";
    private static final String TRACE_MASKF = "HCONVPDF";
    private static final String TRACE_MASKD = "HCONVPDD";
    private static final String VPD_FILENAME = "iqyvpd.dat";
    private static final String BACKUP_VPD_FILENAME = "iqyvpd2b.dat";
    private static final String UNSENSED_VPD_FILENAME = "iqyvpdmc.dat";
    public static final String HMCA_FILENAME = "actvhmca.dat";
    private static final String HMCA_DESCRIPTION = "HMCHDR";
    boolean partialVpd;
    private static final int HCON_PARTIAL_SUCCESS = 170;
    private String ecPartNumber = "";
    private String ecNumber = "";
    private String ecSerialNumber = "";
    private String platform = "";
    private NativeBridge bridge;

    public VpdTasks() {
        Trace.trace(TRACE_MASKT, "<> VpdTasks ctor");
        try {
            SimServer simServer = SimServer.getSimServer();
            byte[] type = simServer.readSim(5);
            if (type != null && type.length > 0) {
                switch (type[0]) {
                    case 1: {
                        this.platform = "ZSE";
                        break;
                    }
                    case 2: {
                        this.platform = "ZHMC";
                        break;
                    }
                    case 4: {
                        this.platform = "PHMC";
                        break;
                    }
                    default: {
                        this.platform = "ZHMC";
                    }
                }
            }
            Trace.trace(TRACE_MASKF, "Platform = " + this.platform);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception getting platform type = " + e);
            e.printStackTrace();
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 31011, new HException(e)).log();
        }
    }

    public void rebuildVpd() throws HException {
        Trace.trace(TRACE_MASKT, "-> VpdTasks.rebuildVpd()");
        this.partialVpd = false;
        try {
            int rc = 0;
            this.bridge = new NativeBridge();
            NativeProcessParameters nativeProcessParameters = null;
            if (this.platform.equals("ZHMC") || this.platform.equals("PHMC")) {
                nativeProcessParameters = new NativeProcessParameters("actzNativeBridgeMain");
                this.bridge.exec(nativeProcessParameters);
                String vpdQFileName = BaseFileControl.getFilePath(VPD_FILENAME) + VPD_FILENAME;
                String backupVpdQFileName = BaseFileControl.getFilePath(BACKUP_VPD_FILENAME) + BACKUP_VPD_FILENAME;
                Trace.trace(TRACE_MASKF, "vpdQFileName is : " + vpdQFileName);
                Trace.trace(TRACE_MASKF, "backupVpdQFileName is : " + backupVpdQFileName);
                File vpdFile = new File(vpdQFileName);
                if (vpdFile.exists()) {
                    FileUtilities.copy(vpdQFileName, backupVpdQFileName);
                }
                String unsensedVpdQFileName = BaseFileControl.getFilePath(UNSENSED_VPD_FILENAME) + UNSENSED_VPD_FILENAME;
                Trace.trace(TRACE_MASKF, "unsensedVpdQFileName is : " + unsensedVpdQFileName);
                FileUtilities.copy(unsensedVpdQFileName, vpdQFileName);
                this.getSystemEcNumber();
                this.updateMicrocodeVpd();
                Object result = this.bridge.invokeNativeFunction("iqyp35pn", "java_xp33_35pn", null);
                rc = (Integer)result;
            } else {
                String[] command = new String[]{"iqyvsein", "REINITNODM"};
                nativeProcessParameters = new NativeProcessParameters(command);
                NativeProcess p = NativeProcess.exec(nativeProcessParameters);
                rc = p.waitFor();
                if (rc == 170) {
                    this.partialVpd = true;
                    rc = 0;
                }
            }
            if (rc != 0) {
                HException hExc = null;
                if (this.platform.equals("ZHMC") || this.platform.equals("PHMC")) {
                    Trace.trace(TRACE_MASKF, "The java_xp33_35pn C function failed with system rc = " + rc);
                    hExc = new HException("java_xp33_35pn C function failed.");
                    new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 31002, hExc).log();
                } else {
                    Trace.trace(TRACE_MASKF, "The call to iqyvsein failed with system rc = " + rc);
                    hExc = new HException("iqyvsein C function failed.");
                    new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 31010, hExc).log();
                }
                throw hExc;
            }
            if (this.platform.equals("ZHMC") || this.platform.equals("PHMC")) {
                FrameworkEventText frameworkEventText = new FrameworkEventText(83);
                String eventName = "CONHONE";
                SystemEventLog systemEventLog = new SystemEventLog(frameworkEventText, eventName);
                systemEventLog.log();
            }
        }
        catch (NativeBridgeException nbe) {
            Trace.trace(TRACE_MASKF, "A NativeBridgeException occured during NativeBridge processing during VpdTasks.rebuildVpd().");
            Trace.trace(TRACE_MASKF, "  The error code is " + nbe.getErrorCode());
            Trace.trace(TRACE_MASKF, nbe);
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 31001, nbe).log();
            throw nbe;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException during VpdTasks.rebuildVpd()");
            Trace.trace(TRACE_MASKF, e);
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 30995, e).log();
            throw e;
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "An IOException occured during NativeBridge processing during VpdTasks.rebuildVpd()");
            Trace.trace(TRACE_MASKF, ioe);
            HException hExc = new HException(ioe);
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 31000, hExc).log();
            throw hExc;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during VpdTasks.rebuildVpd()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = new HException(e);
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 30996, hExc).log();
            throw hExc;
        }
        Trace.trace(TRACE_MASKT, "<- VpdTasks.rebuildVpd()");
    }

    public void createHmca() throws HException {
        byte[] fileContents = null;
        Trace.trace(TRACE_MASKT, "-> VpdTasks.createHmca()");
        try {
            fileContents = this.readFileContent(BaseFileControl.getFilePath(VPD_FILENAME) + VPD_FILENAME);
            String hmcaQFileName = BaseFileControl.getFilePath(HMCA_FILENAME) + HMCA_FILENAME;
            Trace.trace(TRACE_MASKF, "hmcaQFileName is : " + hmcaQFileName);
            this.setDescription(HMCA_DESCRIPTION);
            this.setNumVpdRecords(Integer.toString(fileContents.length / 129));
            DataOutputStream hmcaFile = new DataOutputStream(new FileOutputStream(hmcaQFileName));
            this.writeFileHeader(hmcaFile);
            hmcaFile.write(fileContents);
            hmcaFile.close();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException during VpdTasks.createHmca()");
            Trace.trace(TRACE_MASKF, e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 30997, e).log();
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during VpdTasks.createHmca()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = new HException(e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 30998, hExc).log();
            throw hExc;
        }
        Trace.trace(TRACE_MASKT, "<- VpdTasks.createHmca()");
    }

    public void transmitHmcaToRetain() throws HException {
        Trace.trace(TRACE_MASKT, "<- VpdTasks.transmitHmcaToRetain()");
        try {
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            this.doRsfTransmit(rsf, BaseFileControl.getFilePath(HMCA_FILENAME) + HMCA_FILENAME);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException during VpdTasks.transmitHmcaToRetain()");
            Trace.trace(TRACE_MASKF, e);
            throw e;
        }
        Trace.trace(TRACE_MASKT, "<- VpdTasks.transmitHmcaToRetain()");
    }

    private void getSystemEcNumber() throws HException {
        Trace.trace(TRACE_MASKT, "-> VpdTasks.getSystemEcNumber()");
        UpdateManager um = UpdateManager.getUpdateManager();
        List ecList = um.getTowerUpdateableComponents();
        if (!ecList.isEmpty()) {
            boolean found = false;
            Iterator iterator = ecList.iterator();
            while (iterator.hasNext() && !found) {
                ECStream upComp = (ECStream)iterator.next();
                Trace.trace(TRACE_MASKF, "upComp.getName() = " + upComp.getName());
                if (!upComp.getName().equals("SYSTEM")) continue;
                found = true;
                this.ecPartNumber = upComp.getPartNumber();
                this.ecNumber = upComp.getECNumber();
                int irecMcl = upComp.getStagedLevel();
                int iactMcl = upComp.getAppliedLevel();
                Trace.trace(TRACE_MASKF, "Part Number = " + this.ecPartNumber);
                Trace.trace(TRACE_MASKF, "EC Number = " + this.ecNumber);
                Trace.trace(TRACE_MASKF, "recMcl = " + irecMcl);
                Trace.trace(TRACE_MASKF, "actMcl = " + iactMcl);
                String recMcl = irecMcl == 0 || irecMcl == -1 ? new String("000") : new String(Integer.toString(irecMcl));
                String actMcl = iactMcl == 0 || iactMcl == -1 ? new String("000") : new String(Integer.toString(iactMcl));
                this.ecSerialNumber = recMcl.concat(".").concat(actMcl);
                Trace.trace(TRACE_MASKF, "Serial Number = " + this.ecSerialNumber);
            }
            if (!found) {
                Trace.trace(TRACE_MASKF, "System Ec was not found");
                HException hExc = new HException("System Ec was not found");
                new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 30993, hExc).log();
                throw hExc;
            }
        } else {
            Trace.trace(TRACE_MASKF, "No Ecs were found");
            HException hExc = new HException("No Ecs were found");
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 30992, hExc).log();
            throw hExc;
        }
        Trace.trace(TRACE_MASKT, "<- VpdTasks.getSystemEcNumber()");
    }

    private void updateMicrocodeVpd() throws HException {
        Trace.trace(TRACE_MASKT, "-> VpdTasks.updateMicrocodeVpd()");
        try {
            VpdManager vpdmgr = VpdManager.getVpdManager();
            VpdData vpd = new VpdData(VpdRequestValue.CONFIG_REQUEST);
            vpd = vpdmgr.callVpdManager(vpd);
            String machineType = vpd.getVpdConfigurationExistData().getMachineType();
            String machineModel = vpd.getVpdConfigurationExistData().getMachineModel();
            String machineSerial = vpd.getVpdConfigurationExistData().getMachineSerial();
            String currentTod = this.getTimeStamp();
            Trace.trace(TRACE_MASKF, "Machine Type = " + machineType);
            Trace.trace(TRACE_MASKF, "Machine Model = " + machineModel);
            Trace.trace(TRACE_MASKF, "Machine Serial = " + machineSerial);
            Trace.trace(TRACE_MASKF, "currentTod =" + currentTod);
            VpdData newVpd = new VpdData(VpdRequestValue.ALTER);
            newVpd.getVpdInputData().setFruLocation("A00M_LIC");
            newVpd.getVpdFruNewData().setPartNumber(this.ecPartNumber);
            newVpd.getVpdFruNewData().setEcLevel(this.ecNumber);
            newVpd.getVpdFruNewData().setSerialNumber(this.ecSerialNumber);
            newVpd.getVpdFruNewData().setCcin("PCLC");
            newVpd.getVpdFruNewData().setTod(currentTod);
            newVpd.getVpdDeviceNewData().setMachineType(machineType);
            newVpd.getVpdDeviceNewData().setMachineModel(machineModel);
            newVpd.getVpdDeviceNewData().setMachineSerial(machineSerial);
            VpdData vpdOutput = vpdmgr.callVpdManager(newVpd);
        }
        catch (VpdManagerException ex) {
            Trace.trace(TRACE_MASKF, " VpdTasks.updateMicrocodeVpd VPDManager call failed = :" + ex.getMessage());
            HException hExc = new HException(ex);
            new FrameworkLog(VpdErrorIds.REBUILDVPD_LOGINFO, 30994, hExc).log();
            throw hExc;
        }
        Trace.trace(TRACE_MASKT, "<- VpdTasks.updateMicrocodeVpd()");
    }
}

